/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.msgsvc;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.FcsSupporter;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.MessageId;
import com.ibm.hwmca.fw.util.msgsvc.MessageSubscriber;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntityStateEvent;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntityStateListener;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntityThread;
import com.ibm.hwmca.fw.util.msgsvc.RemoteMsgSvcSupporter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MessageService {
    private static final String TRACE_MASKT = "XMSGSVCT";
    private static final String TRACE_MASKF = "XMSGSVCF";
    private static final String TRACE_MASKD = "XMSGSVCD";
    private static MessageService msgsvc = null;
    private Map deliveryMap = new HashMap();
    protected static final String DM_SUFFIX_ID2SUB = "id2sub";
    protected static final String DM_SUFFIX_SUB2ID = "sub2id";
    private Set remoteSupporterSet = new HashSet();
    private Set reStateListenerSet = new HashSet();
    public static final String LOCAL_SENDER = "LOCAL";

    private MessageService() {
        this.createDeliveryPartition("local");
        this.addRemoteSupporter(new FcsSupporter());
    }

    public static synchronized MessageService getMessageService() {
        if (msgsvc == null) {
            msgsvc = new MessageService();
        }
        return msgsvc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDeliveryPartition(String partitionId) {
        Map map = this.deliveryMap;
        synchronized (map) {
            this.deliveryMap.put(partitionId + DM_SUFFIX_ID2SUB, new HashMap());
            this.deliveryMap.put(partitionId + DM_SUFFIX_SUB2ID, new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteSupporter(RemoteMsgSvcSupporter rmsSupporter) {
        Trace.trace(TRACE_MASKD, "adding RemoteMsgSvcSupporter");
        Set set = this.remoteSupporterSet;
        synchronized (set) {
            this.remoteSupporterSet.add(rmsSupporter);
            this.createDeliveryPartition(rmsSupporter.getPartitionId());
        }
    }

    public void publish(Message msg) {
        Trace.trace(TRACE_MASKD, "--> publish (local; msgid=" + msg.getMessageId().getId() + ")");
        Set subscriberSet = this.getDeliverySet(msg, "local");
        this.deliverTo(msg, subscriberSet, LOCAL_SENDER);
        Trace.trace(TRACE_MASKD, "<-- publish");
    }

    public void publishToRemote(Message msg, Set targetSet, boolean concurrent, boolean localToo) throws HException {
        Set sendSet;
        Trace.trace(TRACE_MASKD, "--> publishToRemote (msgid=" + msg.getMessageId().getId() + ")");
        if (localToo) {
            this.publish(msg);
        }
        if ((sendSet = targetSet) == null) {
            sendSet = this.getAllAcceptingTargets(msg.getMessageId());
        }
        if (sendSet.isEmpty()) {
            Trace.trace(TRACE_MASKD, "No known remote targets");
        } else {
            Iterator sendIter = sendSet.iterator();
            RemoteEntity re = null;
            while (sendIter.hasNext()) {
                re = (RemoteEntity)sendIter.next();
                if (concurrent) {
                    RemoteEntityThread.getRemoteEntityThread(re).queuePublication(msg);
                    continue;
                }
                re.publish(msg);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- publishToRemote");
    }

    public void publishToRemote(Message msg, Set targetSet, boolean localToo) throws HException {
        this.publishToRemote(msg, targetSet, true, localToo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllAcceptingTargets(MessageId msgid) {
        HashSet sendSet = new HashSet();
        Set set = this.remoteSupporterSet;
        synchronized (set) {
            Iterator suppIter = this.remoteSupporterSet.iterator();
            Set newSet = null;
            while (suppIter.hasNext()) {
                newSet = ((RemoteMsgSvcSupporter)suppIter.next()).getAcceptingTargets(msgid);
                if (newSet == null || newSet.isEmpty()) continue;
                sendSet.addAll(newSet);
            }
        }
        return sendSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getDeliverySet(Message msg, String partitionId) {
        Set deliverySet = null;
        Map map = this.deliveryMap;
        synchronized (map) {
            Map id2subMap = (Map)this.deliveryMap.get(partitionId + DM_SUFFIX_ID2SUB);
            HashSet subSet = (HashSet)id2subMap.get(msg.getMessageId());
            if (subSet != null && !subSet.isEmpty()) {
                deliverySet = (Set)subSet.clone();
            }
        }
        return deliverySet;
    }

    private void deliverTo(Message msg, Set subscriberSet, Object sender2) {
        Trace.trace(TRACE_MASKD, "--> deliverTo (msgid=" + msg.getMessageId().getId() + ")");
        if (subscriberSet != null && !subscriberSet.isEmpty()) {
            Iterator subIter = subscriberSet.iterator();
            while (subIter.hasNext()) {
                ((MessageSubscriber)subIter.next()).receiveMessage(msg, sender2);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- deliverTo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverFromRemote(Message msg, RemoteEntity sender2) {
        Trace.trace(TRACE_MASKD, "--> deliverFromRemote (sender=" + sender2 + ")");
        HashSet subscriberSet = new HashSet();
        Set tempSet = null;
        Set set = this.remoteSupporterSet;
        synchronized (set) {
            Iterator suppIter = this.remoteSupporterSet.iterator();
            while (suppIter.hasNext()) {
                tempSet = this.getDeliverySet(msg, ((RemoteMsgSvcSupporter)suppIter.next()).getPartitionId());
                if (tempSet == null || tempSet.isEmpty()) continue;
                subscriberSet.addAll(tempSet);
            }
        }
        this.deliverTo(msg, subscriberSet, sender2);
        Trace.trace(TRACE_MASKD, "<-- deliverFromRemote");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Set msgidSet, MessageSubscriber subscriber, String partitionId) {
        if (msgidSet == null || msgidSet.isEmpty()) {
            return;
        }
        Trace.trace(TRACE_MASKD, "--> subscribe (partition=" + partitionId + ")");
        Map map = this.deliveryMap;
        synchronized (map) {
            Map id2subMap = (Map)this.deliveryMap.get(partitionId + DM_SUFFIX_ID2SUB);
            Map sub2idMap = (Map)this.deliveryMap.get(partitionId + DM_SUFFIX_SUB2ID);
            Iterator idIter = msgidSet.iterator();
            MessageId id = null;
            HashSet<MessageSubscriber> subscriberSet = null;
            while (idIter.hasNext()) {
                id = (MessageId)idIter.next();
                subscriberSet = (HashSet<MessageSubscriber>)id2subMap.get(id);
                if (subscriberSet == null) {
                    subscriberSet = new HashSet<MessageSubscriber>();
                    id2subMap.put(id, subscriberSet);
                }
                subscriberSet.add(subscriber);
            }
            HashSet subbedSet = (HashSet)sub2idMap.get(subscriber);
            if (subbedSet == null) {
                subbedSet = new HashSet();
                sub2idMap.put(subscriber, subbedSet);
            }
            subbedSet.addAll(msgidSet);
        }
        Trace.trace(TRACE_MASKD, "<-- subscribe (partition=" + partitionId + ")");
    }

    public void subscribe(MessageId msgid, MessageSubscriber subscriber) {
        HashSet<MessageId> msgidSet = new HashSet<MessageId>();
        msgidSet.add(msgid);
        this.subscribe(msgidSet, subscriber);
    }

    public void subscribe(Set msgidSet, MessageSubscriber subscriber) {
        this.subscribe(msgidSet, subscriber, "local");
    }

    public void subscribeToRemote(MessageId msgid, MessageSubscriber subscriber, boolean localToo) {
        HashSet<MessageId> msgidSet = new HashSet<MessageId>();
        msgidSet.add(msgid);
        this.subscribeToRemote(msgidSet, subscriber, localToo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToRemote(Set msgidSet, MessageSubscriber subscriber, boolean localToo) {
        Trace.trace(TRACE_MASKD, "--> subscribeToRemote");
        if (localToo) {
            this.subscribe(msgidSet, subscriber);
        }
        Set set = this.remoteSupporterSet;
        synchronized (set) {
            Iterator suppIter = this.remoteSupporterSet.iterator();
            RemoteMsgSvcSupporter rmss = null;
            while (suppIter.hasNext()) {
                rmss = (RemoteMsgSvcSupporter)suppIter.next();
                this.subscribe(msgidSet, subscriber, rmss.getPartitionId());
                rmss.beginAccepting(msgidSet);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- subscribeToRemote");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Set msgidSet, MessageSubscriber subscriber, String partitionId) {
        Trace.trace(TRACE_MASKD, "--> unsubscribe (partition=" + partitionId + ")");
        Map map = this.deliveryMap;
        synchronized (map) {
            Map sub2idMap = (Map)this.deliveryMap.get(partitionId + DM_SUFFIX_SUB2ID);
            Map id2subMap = (Map)this.deliveryMap.get(partitionId + DM_SUFFIX_ID2SUB);
            Set subbedSet = (Set)sub2idMap.get(subscriber);
            if (subbedSet == null || subbedSet.isEmpty()) {
                Trace.trace(TRACE_MASKD, "<-- unsubscribe (partition=" + partitionId + ")");
                return;
            }
            Set removeSet = msgidSet;
            if (removeSet == null || removeSet.isEmpty()) {
                removeSet = (Set)((HashSet)subbedSet).clone();
            }
            subbedSet.removeAll(removeSet);
            Iterator idIter = removeSet.iterator();
            while (idIter.hasNext()) {
                MessageId msgid = (MessageId)idIter.next();
                ((Set)id2subMap.get(msgid)).remove(subscriber);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- unsubscribe (partition=" + partitionId + ")");
    }

    public void unsubscribe(MessageSubscriber subscriber) {
        this.unsubscribe((Set)null, subscriber);
    }

    public void unsubscribe(MessageId msgid, MessageSubscriber subscriber) {
        HashSet<MessageId> idSet = new HashSet<MessageId>();
        idSet.add(msgid);
        this.unsubscribe(idSet, subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Set msgidSet, MessageSubscriber subscriber) {
        Trace.trace(TRACE_MASKD, "--> unsubscribe");
        this.unsubscribe(msgidSet, subscriber, "local");
        Set set = this.remoteSupporterSet;
        synchronized (set) {
            Iterator suppIter = this.remoteSupporterSet.iterator();
            RemoteMsgSvcSupporter rmss = null;
            while (suppIter.hasNext()) {
                rmss = (RemoteMsgSvcSupporter)suppIter.next();
                this.unsubscribe(msgidSet, subscriber, rmss.getPartitionId());
                rmss.stopAccepting(msgidSet);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- unsubscribe");
    }

    protected void remoteEntityStateChanged(RemoteEntityStateEvent reStateEvent) {
        this.fireRemoteEntityStateChanged(reStateEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addREStateListener(RemoteEntityStateListener reStateListener) {
        Set set = this.reStateListenerSet;
        synchronized (set) {
            this.reStateListenerSet.add(reStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeREStateListener(RemoteEntityStateListener reStateListener) {
        Set set = this.reStateListenerSet;
        synchronized (set) {
            this.reStateListenerSet.remove(reStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteEntityStateChanged(RemoteEntityStateEvent reStateEvent) {
        Trace.trace(TRACE_MASKD, "--> fireRemoteEntityStateChanged");
        Trace.trace(TRACE_MASKD, "firing: " + reStateEvent);
        Set set = this.reStateListenerSet;
        synchronized (set) {
            Iterator listenerIter = this.reStateListenerSet.iterator();
            while (listenerIter.hasNext()) {
                ((RemoteEntityStateListener)listenerIter.next()).remoteEntityStateChanged(reStateEvent);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- fireRemoteEntityStateChanged");
    }
}

